// Categories
function categories()
{
	var $categories = $('#categories'), $left = $('#categories_left'), $right = $('#categories_right');
	
	if(!$categories.size())
	{
		return;
	}
	
	var categories_width = $categories.outerWidth();
	var container_width = $('#categories_container').outerWidth() - 2;
	
	if(!$left.size())
	{
		$categories.css(
		{
			'visibility': 'visible',
			'position': 'absolute',
			'width': container_width - 18,
			'padding-left': 10,
			'padding-right': 10,
			'z-index': 0
		});
		
		return;
	}
	
	var $current = $('a.current', $categories);
	
	var offset = container_width/2 - $current.offset().left - $current.width()/2;
	
	if(categories_width > container_width)
	{
		if(offset > 0)
		{
			$left.addClass('disabled');
			
			offset = 0;
		} else if(offset < container_width - categories_width)
		{
			$right.addClass('disabled');
			
			offset = container_width - categories_width;
		}
		
		$categories.css(
		{
			'visibility': 'visible',
			'position': 'absolute',
			'width': $categories.width()+'px',
			'left': offset
		});
		
		$left.mousedown(function(e)
		{
			e.preventDefault();
			
			$right.removeClass('disabled');
			
			$categories.animate({'left': 0}, -3*parseInt($categories.css('left')), 'linear', function()
			{
				$left.addClass('disabled');
			});
		}).mouseup(function()
		{
			$categories.stop();
		});
		
		$right.mousedown(function(e)
		{
			e.preventDefault();
			
			$left.removeClass('disabled');
			
			$categories.animate({'left': container_width - categories_width}, (categories_width - container_width + parseInt($categories.css('left')))*3, 'linear', function()
			{
				$right.addClass('disabled');
			});
		}).mouseup(function()
		{
			$categories.stop();
		});
	} else
	{
		$left.remove();
		$right.remove();
		
		$categories.css(
		{
			'visibility': 'visible',
			'position': 'absolute',
			'width': container_width - 18,
			'padding-left': 10,
			'padding-right': 10
		});
	}
}

// Games
function games()
{
	var $games = $('div.box.game').hover(function()
	{
		if(!$(this).hasClass('ad'))
		{
			$(this).addClass('hover');
		}
	}, function()
	{
		$(this).removeClass('hover');
	}).mousedown(function(e)
	{
		if($(this).hasClass('ad'))
		{
			return;
		}
			
		if(e.ctrlKey || e.which === 2)
		{
			window.open(play_path.replace('{slug}', this.id.substr(5)), '_blank');
			window.focus();
		} else if(e.which === 1)
		{
			window.location.href = play_path.replace('{slug}', this.id.substr(5));
		}
	});
}

// Spotlight
function spotlight()
{
	var $spotlight = $('#spotlight');
	
	if(!$spotlight.size())
	{
		return;
	}
	
	$spotlight.css(
	{
		'visibility': 'visible',
		'position': 'absolute',
		'width': $spotlight.width()+'px',
		'left': 10
	});
	
	if(!$('#spotlight_nav').size())
	{	
		return;
	}
	
	var spotlight_width = $spotlight.outerWidth();
	var container_width = $('#spotlight_container').outerWidth() - 2;
	
	var $nav = $('#spotlight_nav a').click(function()
	{
		var $this = $(this);
		
		index = $this.index();
		
		$nav.removeClass('current').eq(index).addClass('current');
		
		$spotlight.animate({'left': -index*260+10}, 400);
	});
	
	var max = $nav.size();
	
	var interval, index = 0, intervalHandler = function()
	{
		interval = setInterval(function()
		{
			index++;
			
			if(index == max)
			{
				index = 0;
			}
			
			$nav.removeClass('current').eq(index).addClass('current');
			
			$spotlight.animate({'left': -index*260+10}, 400);
		}, 5000);
	};
	
	$spotlight.hover(function()
	{
		clearInterval(interval);
	}, function()
	{
		intervalHandler();
	});
	
	$('#spotlight_nav').hover(function()
	{
		clearInterval(interval);
	}, function()
	{
		intervalHandler();
	});
	
	intervalHandler();
}

// Search
function search()
{
	var $search = $('#search'), $input = $('#search_input');
	
	if(!$search.size())
	{
		return;
	}
	
	$search.submit(function(e)
	{
		e.preventDefault();
		
		if($input.val() !== '')
		{
			window.location.href = search_path.replace('{input}', escape($input.val().replace('/', ' ')));
		}
	});
}

// Ready
$(function()
{
	categories();
	games();
	spotlight();
	search();
});